{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either LVERSION 3 of the License, or
    (at your option) any later LVERSION.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.


    Help --> About menu item handling
}


unit UAbout;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls;

type

  { TFAbout }

  TFAbout = class(TForm)
    BOK: TButton;
    ISKLOGO: TImage;
    LNAME: TLabel;
    LDESC: TLabel;
    LTRASLATOR: TLabel;
    LVERSION: TLabel;
    LDISCLAIMER: TLabel;
    procedure BOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FAbout: TFAbout;

implementation

{$R *.lfm}

{ TFAbout }

uses Skanti;

// 'OK' button handling
procedure TFAbout.BOKClick(Sender: TObject);
begin
  FAbout.Hide;
end;

// Load version info
procedure TFAbout.FormCreate(Sender: TObject);
begin
  FAbout.LVERSION.Caption := LongVersion+LineEnding+'i1epj@aricasale.it';
end;

end.

