{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units. The CU
    firmware version can be either 80R or 92.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.


    Help --> GNU License manu item handling
}

unit UGNU;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  DefaultTranslator;

type

  { TFGNU }

  TFGNU = class(TForm)
    BOK: TButton;
    GNUmemo: TMemo;
    procedure BOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FGNU: TFGNU;
  OW, OH, OFH: integer;

implementation

uses Skanti;

{$R *.lfm}

{ TFGNU }

// 'OK' button handling
procedure TFGNU.BOKClick(Sender: TObject);
begin
  FGNU.Hide;
end;

// At startup, load GPL v3 license into GNUMEMO memo - always the english version
procedure TFGNU.FormCreate(Sender: TObject);
begin
  // Read in the GPLv3 license file
  GNUMemo.Lines.LoadFromFile(DocDir+'gpl-3.0.txt');

  // Save starting width, height & font height
  OW := FGNU.Width;
  OH := FGNU.Height;
  OFH := GNUMEMO.Font.Height;
end;

// Scale form when shown
procedure TFGNU.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
  NewFontHeight := (OFH * FontMagn) div 100;
  GNUMEMO.Font.Height := NewFontHeight;
  FGNU.Width := (OW * FontMagn) div 100;
  FGNU.Height := (OH * FontMagn) div 100;
  FGNU.Left := (Screen.Width-FGNU.Width) div 2;
  FGNU.Top := (Screen.Height-FGNU.Height) div 2;
end;

end.

