{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units. The CU
    firmware version can be either 80R or 92.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.


    Minimum (and wrong) implementation of the dump_state rigctld command,
    which is required for WSJTX and other programs to work.

    It is only what is returned by rigctld in reply to dump_state command
    for the TRP8255 S R rig, with some capabilities added by trial and error.

    Must be totally rewritten with all supported capabilities.

    TBD
}

unit UState;

{$mode ObjFPC}

interface

uses
  Classes, SysUtils;

// This is what is returned by rigctld in response to the dump_state command for
// TRP8255 S R rig model, with some modifications by trial an error, since the
// meaning of most of these bytes is unknown to me.
var TRP8255_State: array of string = (
'1',
'14004',  // rig model
'0',
'1600000.000000 30000000.000000 0x1 4000 40000 0x1 0x0',    // Frequency limits?
'1600000.000000 30000000.000000 0x1e 10000 100000 0x1 0x0',
'0 0 0 0 0 0 0',
'500000.000000 30000000.000000 0x1f -1 -1 0x1 0x0',    // More frequency limits?
'0 0 0 0 0 0 0',
'0x1f 10',      // these should be the tuning steps
'0x1f 100',
'0x1f 1000',
'0 0',
// the filters available by mode
'0x10 250',           // RTTY Normal
'0x10 250',           // RTTY Wide
'0x10 250',           // RTTY Narrow
'0x08 2700',          // LSB Normal
'0x08 2700',          // LSB Wide
'0x08 2700',          // LSB Narrow
'0x04 2700',          // USB Normal
'0x04 2700',          // USB Wide
'0x04 2700',          // USB Narrow
'0x02 1000',          // CW Normal
'0x02 2700',          // CW Wide
'0x02 250',           // CW Narrow
'0x01 6000',          // AM Normal
'0x01 6000',          // AM Wide
'0x01 6000',          // AM Narrow
'0 0',
'0',
'0',
'0',
'0',
'10',
'20',
'0x120000',         // Function read:  MUTE, SQL
'0x120000',         // Function write: MUTE, SQL
'0x4002101b',       // Level read: PREAMP, ATT, AF, RF, RFPOWER, AGC, STRENGTH
'0x02101b',         // Level write: PREAMP, ATT, AF, RF, RFPOWER, AGC
'0x0',
'0x24',
'done'
);

implementation

end.

