{
    This file is part of RA1792Control

    RACAL RA1792 Control program

    Copyright (C) 2014-2022 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

                                   * * *

    GNU License showing form
}

unit UGNU;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFGNU }

  TFGNU = class(TForm)
          Button1: TButton;
          GNUmemo: TMemo;
          procedure Button1Click(Sender: TObject);
          procedure FormCreate(Sender: TObject);
          procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FGNU: TFGNU;
  OW, OH, OFH: integer;

implementation

{$R *.lfm}

uses ura3701;

{ TFGNU }

procedure TFGNU.Button1Click(Sender: TObject);
begin
        FGNU.Hide;
end;

// At start, load the GPL in the memo and save window start data
procedure TFGNU.FormCreate(Sender: TObject);
begin
  // Read in the english text version of the GNU GPL
  GNUMEMO.Lines.LoadFromFile(GPLv3Dir+'gpl-3.0.txt');

  // Save starting width, height & font height
  OW := FGNU.Width;
  OH := FGNU.Height;
  OFH := GNUMEMO.Font.Height;
end;

// Window & text scaling
procedure TFGNU.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
    NewFontHeight := (OFH * FontMagn) div 100;
    GNUMEMO.Font.Height := NewFontHeight;
    FGNU.Width := (OW * FontMagn) div 100;
    FGNU.Height := (OH * FontMagn) div 100;
    FGNU.Left := (Screen.Width-FGNU.Width) div 2;
    FGNU.Top := (Screen.Height-FGNU.Height) div 2;
end;

end.

