{
    This file is part of RA1792Control

    RACAL RA1792 Control program

    Copyright (C) 2014-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.
}


//
// Serial port select dialog
//
unit user;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFSerPort }

  TFSerPort = class(TForm)
          BOK: TButton;
          ESer: TEdit;
          procedure BOKClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FSerPort: TFSerPort;

implementation

{$R *.lfm}

{ TFSerPort }

uses ura1792;

procedure TFSerPort.BOKClick(Sender: TObject);
begin
{$IFDEF LINUX}
    if pos('/dev',Eser.Text) = 0 then
       SerPortName := '/dev/'+Eser.Text
    else
        SerPortName := Eser.Text;
{$ENDIF}
{$IFDEF WINDOWS}
    // The \\.\ syntax is optional for ports 1..9 but is needed
    // for ports > 9, so insert it anyway if not present
    if pos('\\.\',Eser.text) = 0 then
       SerPortName := '\\.\' + Eser.Text
    else
        SerPortName := Eser.Text;
{$ENDIF}
        ra1792.MttyUSB0.Checked := FALSE;
        ra1792.MttyUSB1.Checked := FALSE;
        ra1792.MCustom.Checked := TRUE;
        ra1792.SaveConfig;
        FSerPort.Hide;
end;

end.

