{
    This file is part of EKD500Control

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units.

    Copyright (C) 2012-2022 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.
}

unit Ucopy;

{$mode objfpc}

interface

uses
    Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
    fileutil;

type

    { TFCOPY }

    TFCOPY = class(TForm)
        BCANC: TButton;
        BCOPY: TButton;
        EDCOPYN: TEdit;
        procedure BCANCClick(Sender: TObject);
        procedure BCOPYClick(Sender: TObject);
        procedure FormCreate(Sender: TObject);
        procedure FormShow(Sender: TObject);
    private

    public

    end;

var
    FCOPY: TFCOPY;
    OH,OW,OFH: integer;

resourcestring
  COPYNAMEST = '%s - (copy %d)';
  COPYFAILED = 'Copy failed';

implementation

uses ura1792, umanager;

{ TFCOPY }

procedure TFCOPY.FormCreate(Sender: TObject);
begin
    // Save starting width, height & font height
    OW := FCOPY.Width;
    OH := FCOPY.Height;
    OFH := EDCOPYN.Font.Height;
end;

// Copy a file
procedure TFCOPY.BCOPYClick(Sender: TObject);

var
    OldName,CopyName: string;
    CopyNum: integer = 0;

begin
    OldName := UMGR.TFLB.Filename;
    CopyName := EDCOPYN.Text;
    if ExtractFilePath(Copyname) = '' then
        CopyName := ExtractFilePath(OldName)+CopyName;

    while FileExists(CopyName) do begin
        CopyNum := CopyNum+1;
        CopyName := Format(COPYNAMEST,[Oldname,CopyNum]);
    end;
    if CopyFile(OldName, CopyName) then begin
        FCOPY.Hide;
        UMGR.TFLB.UpdateFileList;
    end else ShowMessage(COPYFAILED);
end;

// Cancel button
procedure TFCOPY.BCANCClick(Sender: TObject);
begin
    FCOPY.Hide;
    UMGR.TFLB.ClearSelection;
end;

// Window scaling
procedure TFCOPY.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
    NewFontHeight := (OFH * FontMagn) div 100;
    EDCOPYN.Font.Height := NewFontHeight;
    FCOPY.Height := (OH * FontMagn) div 100;
    FCOPY.Width := (OW * FontMagn) div 100;
    FCOPY.Top := (Screen.Height-FCOPY.Height) div 2;
    FCOPY.Left := (Screen.Width-FCOPY.Width) div 2;
end;

initialization
    {$I ucopy.lrs}

end.

