{
    This file is part of EKD500Control

    RFT EKD500 Control program

    Copyright (C) 2013-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.
}

unit UGNU;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFGNU }

  TFGNU = class(TForm)
    OK: TButton;
    GNUmemo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure OKClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FGNU: TFGNU;
  OW, OH, OFH: integer;

implementation

uses EKD500;

{$R *.lfm}

{ TFGNU }

procedure TFGNU.OKClick(Sender: TObject);
begin
  FGNU.Hide;
end;

// Initializations at start
procedure TFGNU.FormCreate(Sender: TObject);
begin
  // Read in the GPLv3 license file
  GNUMemo.Lines.LoadFromFile(GPLv3Dir+'gpl-3.0.txt');

  // Save starting width, height & font height
  OW := FGNU.Width;
  OH := FGNU.Height;
  OFH := GNUMEMO.Font.Height;
end;

// Setup window at start
procedure TFGNU.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
  // Apply font magnification factor
  NewFontHeight := (OFH * FontMagn) div 100;
  GNUMEMO.Font.Height := NewFontHeight;
  FGNU.Width := (OW * FontMagn) div 100;
  FGNU.Height := (OH * FontMagn) div 100;
  FGNU.Left := (Screen.Width-FGNU.Width) div 2;
  FGNU.Top := (Screen.Height-FGNU.Height) div 2;
end;

end.

